
*****************************************************
*           REGRESSIONSANALYSE                      *
*              Josef Brüderl                        *
*               Januar 2019                         *
*****************************************************

*****************************************************
* Multinomiale Regressionsmodelle
*****************************************************

clear 
set more off
version 15

* Daten: ALLBUS 2002
cd "C:\Users\bruederl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files\"
use  AllbReg, clear


******************************************
* Bsp.: Wahlabsicht 
******************************************
mlogit partei alter bild ost, base(1)        //CDU als Referenzkategorie


* Test der Signifikanz der Variablen
mlogtest, lr                                 //funktioniert nur mit "SPost"

* Test, ob man Kategorien zusammenlegen kann
mlogtest, lrcomb                             //funktioniert nur mit "SPost"

* Fitmaße
mlogit partei alter bild ost, base(1)
fitstat                                      //funktioniert nur mit "SPost"

* Odds-Ratios
mlogit, rrr

* IIA Annahme
mlogtest, suest base                         //funktioniert nur mit "SPost"


*-----------------------------------------
* Profile-Plots
*-----------------------------------------

* Alter (Ost)
mlogit partei alter bild ost, base(1)
prgen alter, from(18) to(83) x(ost 1) generate(o)           //funktioniert nur mit "SPost"
twoway connected op1 op2 op3 op4 op5 ox, title("Wahlabsicht nach Alter im Osten")  /// 
    lwidth(thick thick thick thick thick) lcolor(black red yellow green purple)     ///
    msymbol(i i i i i) ytitle("P(Partei=m)", size(large))                           ///  
    ylabel(0(0.1)0.5, labsize(medlarge) angle(horizontal) grid format(%3.1f))       ///
    xtitle("Alter", size(large) margin(medsmall))                                   ///  
    xlabel(20(10)80, labsize(medlarge))                                             ///
    legend(pos(11) ring(0) col(2) lab(1 CDU) lab(2 SPD) lab(3 FDP)                  ///
	       lab(4 "Grüne") lab(5 PDS) size(medlarge))                                ///
    ysize(5)

* Alter (Ost), gestapelte Version
gen zero=0
gen one=1
drop os1 os2 os3 os4             //scheinen irgendwie falsch berechnet zu sein
gen os1=op1
gen os2=op1+op2
gen os3=op1+op2+op3
gen os4=op1+op2+op3+op4
twoway                                  ///
    (rarea zero os1 ox, bc(black))      ///
    (rarea  os1 os2 ox, bc(red))        ///
	(rarea  os2 os3 ox, bc(yellow))     ///
	(rarea  os3 os4 ox, bc(green))      ///
	(rarea  os4 one ox, bc(purple)),    ///
	title("Wahlabsicht nach Alter im Osten")                                 /// 
    ytitle("P summiert", size(large))                                        ///  
    ylabel(0(0.25)1, labsize(medlarge) angle(horizontal) grid format(%4.2f)) ///
    xtitle("Alter", size(large) margin(medsmall))                            ///  
    xlabel(20(10)80, labsize(medlarge))                                      ///
    legend(lab(1 CDU) lab(2 SPD) lab(3 FDP)                                  ///
	       lab(4 "Grüne") lab(5 PDS) size(medlarge))                           

   
*-----------------------------------------
* Wahrscheinlichkeitsinterpretation
*-----------------------------------------

* Marginal Effects bzw. Discrete Change
mlogit partei alter bild ost, base(1)
prchange, help      //funktioniert nur, wenn SPost Ados geladen sind


* Average Marginal Effects bzw. Average Discrete Change
gen  bild1  = bild/10
gen  alter1 = alter/30

mlogit partei alter1 bild1 i.ost, base(1)
quietly margins, dydx(*) predict(outcome(1))
marginsplot, horizontal xline(0) plotopts(connect(i)) ///mit Y-Beschriftung
    title("")                                         ///
    xtitle(,  size(medium) margin(medsmall))          ///
    ytitle("")                                        ///
	xlabel(-0.2(0.05)0.2, grid labsize(small))        ///             
    ysize(4) xsize(5) saving(AME1, replace)
forvalues k=2/5 {
  quietly margins, dydx(*) predict(outcome(`k'))
  marginsplot, horizontal xline(0) plotopts(connect(i)) ///ohne Y-Beschriftung
    title("")                                           ///
    xtitle(,  size(medium) margin(medsmall))            ///
    ytitle("") ylabel("")                               ///
	xlabel(-0.2(0.05)0.2, grid labsize(small))          ///             
    ysize(4) xsize(3) saving(AME`k', replace)
}
graph combine AME1.gph AME2.gph AME3.gph AME4.gph AME5.gph,  ///
              rows(1) iscale(*1.4) xsize(9) ysize(3.5)

			  
*------------------------------------------
* Interaktionseffekte
*------------------------------------------   

* Slope Interaktion: Ost##(Alter Alter2)
mlogit   partei bild i.ost##(c.alter c.alter#c.alter), base(1)  
test 1.ost#c.alter 1.ost#c.alter#c.alter

* Profile-Plot
* Alterseffekt getrennt für Ost/West für p(PDS)
margins ost, at(alter=(18(5)83)) noatlegend predict(outcome(5))
marginsplot,   noci   title("CEP Interaktion Ost#(Alter Alter2)")      ///
   plot1opts(lwidth(thick) lcolor(red)  msymbol(i))                    ///
   plot2opts(lwidth(thick) lcolor(blue) msymbol(i))                    ///
   ytitle("P(PDS)", size(large))                                       ///  
   ylabel(0(0.05)0.5, labsize(medlarge) angle(horizontal) grid format(%4.2f))  ///
   xtitle("Alter", size(large) margin(medsmall))                        ///  
   xlabel(20(10)80, labsize(medlarge))                                  ///
   legend(pos(11) ring(0) row(2) order(1 2) lab(1 "Westdeutscher")      ///
		     lab(2 "Ostdeutscher") size(medlarge))                      ///
   ysize(5)

* Conditional-Effekt-Plot
* Ost-Effekt auf P(CDU) varriert mit dem Alter
margins, at(alter=(18(2)82)) dydx(ost) noatlegend predict(outcome(1))
marginsplot,   recast(line) recastci(rline)                         ///
        plotopts(lwidth(thick) lcolor(blue))                        ///
		ciopts(lcolor(blue) lpattern(dash))                         ///
        ytitle("Differenz P(CDU) zu West", size(medlarge))       ///  
        ylabel(-0.4(0.05)0.1, labsize(medlarge) angle(horizontal)   ///
		        grid format(%4.2f))                                 ///
        xtitle("Alter", size(large) margin(medsmall))               ///  
        xlabel(20(10)80, labsize(medlarge))                         /// 		
		yline(0, lcolor(red))                                       ///
		title("Konditionaler Marginaleffekt von 'Ost' und 95%-KI",  ///
		      size(large) margin(medium))                           ///
        ysize(5)   

		
*---------------------------------------
*  Alternativen
*---------------------------------------
mprobit partei alter bild ost, base(1)    //multinomiales Probit


